/*
 * Decompiled with CFR 0.152.
 */
import com.sun.awt.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;

public class GMATTimer {
    private static boolean isTextShown = true;
    private static int dir = 1;
    private static String minStr;
    private static String minStrTmp;
    private static JDialog optionDialog;
    static Time time;
    static final Color BLUE;
    static final String FORMAT_TIME = "Time Remaining %02d:%02d";
    static final Font FONT_BT;

    public static void main(String[] args) {
        try {
            UIManager.put("Button.font", FONT_BT);
            UIManager.put("Button.background", BLUE);
            UIManager.put("Label.font", FONT_BT);
            UIManager.put("Label.foreground", Color.WHITE);
            UIManager.put("RadioButton.font", FONT_BT);
            UIManager.put("RadioButton.foreground", Color.WHITE);
            UIManager.put("RadioButton.background", BLUE);
            UIManager.put("CheckBox.font", FONT_BT);
            UIManager.put("CheckBox.foreground", Color.WHITE);
            UIManager.put("CheckBox.background", BLUE);
            UIManager.put("OptionPane.messageForeground", Color.WHITE);
            UIManager.put("OptionPane.background", BLUE);
            UIManager.put("Panel.background", BLUE);
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                final JFrame sFrame = new JFrame();
                sFrame.setSize(500, 300);
                sFrame.setLocationRelativeTo(null);
                sFrame.setUndecorated(true);
                final JFrame frame = new JFrame();
                frame.setUndecorated(true);
                frame.setAlwaysOnTop(true);
                final Timer timer = new Timer(1000, null);
                timer.setDelay(1000);
                final JPanel jpTime = new JPanel();
                final JButton timeBt = GMATTimer.makeButton("", new String[]{"clock.png", "clockRollOver.png", "clockPressed.png"}, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JButton timeBt = (JButton)e.getSource();
                        if (isTextShown) {
                            timeBt.setText("");
                            isTextShown = false;
                            jpTime.repaint();
                            jpTime.revalidate();
                        } else {
                            timeBt.setText(String.format(GMATTimer.FORMAT_TIME, time.getMin(), time.getSec()));
                            isTextShown = true;
                        }
                    }
                });
                timer.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        time.add(-dir);
                        if (isTextShown) {
                            timeBt.setText(String.format(GMATTimer.FORMAT_TIME, time.getMin(), time.getSec()));
                        }
                        if (time.equals(new Time(0, 0))) {
                            timer.stop();
                            JOptionPane.showMessageDialog(frame, "Time is up.", "End", -1);
                        }
                    }
                });
                JButton optBt = GMATTimer.makeButton("", new Dimension(15, 28), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (optionDialog == null) {
                            optionDialog = new OptionDialog(frame, timer, timeBt, sFrame);
                        }
                        optionDialog.setVisible(true);
                    }
                });
                jpTime.setLayout(new BoxLayout(jpTime, 0));
                jpTime.setOpaque(false);
                jpTime.add(Box.createGlue());
                jpTime.add(timeBt);
                jpTime.add(optBt);
                frame.add(jpTime);
                JPanel jp = new JPanel(new BorderLayout());
                jp.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
                sFrame.add(jp);
                JLabel title = new JLabel("GMAT Timer Setting", 0);
                title.setFont(new Font("Arial", 1, 24));
                title.setForeground(Color.YELLOW);
                jp.add((Component)title, "North");
                JPanel centerP = new JPanel();
                centerP.setLayout(new BoxLayout(centerP, 1));
                jp.add((Component)centerP, "Center");
                JPanel boxP = new JPanel(new BorderLayout());
                boxP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.WHITE), "Direction", 1, 2, FONT_BT, Color.WHITE));
                centerP.add((Component)boxP, "West");
                final JCheckBox jchb = new JCheckBox("Count Up");
                jchb.setFocusPainted(false);
                boxP.add(jchb);
                String[] name = new String[]{"75", "30", "Custom"};
                String[] comment = new String[]{"Math/Verbal", "AWA -- AA/AI", ""};
                JPanel btP = new JPanel(new GridLayout(1, 1));
                btP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.WHITE), "Time: (min)", 1, 2, FONT_BT, Color.WHITE));
                centerP.add(btP);
                final JPanel btWrp = new JPanel(new FlowLayout(1, 60, 10));
                btP.add(btWrp);
                ButtonGroup btGrp = new ButtonGroup();
                for (int i = 0; i < name.length; ++i) {
                    JPanel tmp = new JPanel(new GridLayout(2, 1));
                    btWrp.add(tmp);
                    JRadioButton jrb = new JRadioButton(name[i]);
                    jrb.setFocusPainted(false);
                    jrb.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            String btText = ((JRadioButton)e.getItem()).getText();
                            if (btText.matches("\\d+")) {
                                minStr = btText;
                            }
                        }
                    });
                    if (i == 0) {
                        jrb.setSelected(true);
                    }
                    btGrp.add(jrb);
                    tmp.add(jrb);
                    if (!comment[i].equals("")) {
                        tmp.add(new JLabel(comment[i]));
                        continue;
                    }
                    final JTextField textF = new JTextField(2);
                    textF.setFont(FONT_BT);
                    JPanel textWr = new JPanel();
                    textWr.add(textF);
                    tmp.add(textWr);
                    textF.addFocusListener(new FocusListener(){

                        @Override
                        public void focusGained(FocusEvent e) {
                            ((JRadioButton)textF.getParent().getParent().getComponent(0)).setSelected(true);
                        }

                        @Override
                        public void focusLost(FocusEvent e) {
                            if (!textF.getText().matches("\\d+")) {
                                JOptionPane.showMessageDialog(sFrame, "Please enter a positive integer.", "Error", 0);
                            } else {
                                minStr = textF.getText();
                            }
                        }
                    });
                }
                jchb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (jchb.isSelected()) {
                            dir = -1;
                            minStrTmp = minStr;
                            minStr = "0";
                            JPanel btP = (JPanel)btWrp.getParent();
                            JLayeredPane layerP = new JLayeredPane();
                            layerP.setPreferredSize(btWrp.getSize());
                            btP.remove(btWrp);
                            btP.add(layerP);
                            Rectangle bound = btWrp.getBounds();
                            bound.y = 0;
                            bound.x = 0;
                            JComponent overlay = new JComponent(){

                                @Override
                                public void paintComponent(Graphics g) {
                                    g.setColor(new Color(100, 100, 100, 150));
                                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                                }
                            };
                            btWrp.setBounds(bound);
                            overlay.setBounds(bound);
                            layerP.add((Component)btWrp, JLayeredPane.DEFAULT_LAYER);
                            layerP.add((Component)overlay, JLayeredPane.PALETTE_LAYER);
                            btP.repaint();
                            btP.revalidate();
                        } else {
                            dir = 1;
                            minStr = minStrTmp;
                            JPanel btP = (JPanel)btWrp.getParent().getParent();
                            btP.removeAll();
                            btP.add(btWrp);
                            btP.repaint();
                            btP.revalidate();
                        }
                    }
                });
                JPanel bottomP = new JPanel();
                bottomP.setLayout(new BoxLayout(bottomP, 0));
                jp.add((Component)bottomP, "South");
                JPanel exitP = new JPanel(null);
                exitP.setPreferredSize(new Dimension(100, 50));
                exitP.setMaximumSize(new Dimension(100, 50));
                bottomP.add(exitP);
                bottomP.add(Box.createHorizontalGlue());
                bottomP.add(GMATTimer.makeButton("Start", new String[]{"box.png", "boxRollOver.png", "boxPressed.png"}, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        sFrame.setVisible(false);
                        time = new Time(Integer.parseInt(minStr), 0);
                        timeBt.setText(String.format(GMATTimer.FORMAT_TIME, time.getMin(), time.getSec()));
                        Rectangle screenRec = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                        frame.pack();
                        frame.setVisible(true);
                        frame.setLocation(screenRec.x + screenRec.width - frame.getWidth(), screenRec.y);
                        AWTUtilities.setWindowOpaque((Window)frame, (boolean)false);
                        timer.start();
                    }
                }));
                bottomP.add(Box.createHorizontalGlue());
                JPanel helpP = new JPanel(null);
                helpP.setPreferredSize(new Dimension(85, 50));
                helpP.setMaximumSize(new Dimension(85, 50));
                bottomP.add(helpP);
                JButton exitBt = GMATTimer.makeButton("", new String[]{"exit_main.png", "exit_over.png", "exit_down.png"}, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.exit(0);
                    }
                });
                exitBt.setBounds(0, 19, 87, 31);
                exitP.add(exitBt);
                JButton helpBt = GMATTimer.makeButton("Help", new String[]{"help.png", "helpRollOver.png", "helpPressed.png"}, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String link = "http://sourceforge.net/p/gmattimer/wiki/Home/";
                        JPanel textP = new JPanel(new GridLayout(2, 1));
                        JLabel label1 = new JLabel("<html>GMAT Timer V1.01<br />By Weel Young</html>");
                        textP.add(label1);
                        JPanel linkP = new JPanel();
                        JLabel label2 = new JLabel("<html><u>http://sourceforge.net/p/gmattimer/wiki/Home/</u></html>");
                        JLabel label3 = new JLabel("Get help from ");
                        label2.setForeground(Color.YELLOW);
                        linkP.add(label3);
                        linkP.add(label2);
                        textP.add(linkP);
                        label2.setCursor(Cursor.getPredefinedCursor(12));
                        label2.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseClicked(MouseEvent me) {
                                try {
                                    Desktop.getDesktop().browse(URI.create("http://sourceforge.net/p/gmattimer/wiki/Home/"));
                                }
                                catch (IOException ex) {
                                    JOptionPane.showMessageDialog(sFrame, "Fail to launch the default web explorer.", "Error", 0);
                                }
                            }
                        });
                        JOptionPane.showMessageDialog(sFrame, textP, "Help", -1);
                    }
                });
                helpBt.setBounds(0, 19, 85, 31);
                helpP.add(helpBt);
                sFrame.setVisible(true);
            }
        });
    }

    public static JButton makeButton(String text, Dimension size, ActionListener lis) {
        JButton jb = new JButton(text);
        jb.setFocusPainted(false);
        jb.setMargin(new Insets(0, 0, 0, 0));
        jb.setPreferredSize(size);
        jb.setMaximumSize(size);
        jb.addActionListener(lis);
        return jb;
    }

    public static JButton makeButton(String text, String[] imgURL, ActionListener lis) {
        JButton jb = new JButton(text, new ImageIcon(GMATTimer.class.getResource("/img/" + imgURL[0])));
        jb.setRolloverIcon(new ImageIcon(GMATTimer.class.getResource("/img/" + imgURL[1])));
        jb.setRolloverEnabled(true);
        jb.setPressedIcon(new ImageIcon(GMATTimer.class.getResource("/img/" + imgURL[2])));
        jb.setContentAreaFilled(false);
        jb.setOpaque(true);
        jb.setForeground(Color.WHITE);
        jb.setCursor(Cursor.getPredefinedCursor(12));
        GMATTimer.changeColorOver(jb, new Color[]{Color.YELLOW, Color.WHITE, Color.GRAY}, 1);
        jb.setFocusPainted(false);
        jb.setBorderPainted(false);
        jb.addActionListener(lis);
        return jb;
    }

    private static void changeColorOver(final AbstractButton jc, final Color[] c, final int pos) {
        jc.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                if (pos == 1) {
                    jc.setForeground(c[0]);
                } else {
                    jc.setBackground(c[0]);
                }
            }

            @Override
            public void mouseExited(MouseEvent me) {
                if (jc.isSelected()) {
                    return;
                }
                if (pos == 1) {
                    jc.setForeground(c[1]);
                } else {
                    jc.setBackground(c[1]);
                }
            }
        });
        if (c.length > 2) {
            jc.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent me) {
                    if (pos == 1) {
                        jc.setForeground(c[2]);
                    } else {
                        jc.setBackground(c[2]);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent me) {
                    if (pos == 1) {
                        jc.setForeground(c[0]);
                    } else {
                        jc.setBackground(c[0]);
                    }
                }
            });
        }
    }

    public static JLabel makeLink(String text, Font font, MouseListener lis) {
        final JLabel jl = new JLabel(text, 0);
        jl.setCursor(Cursor.getPredefinedCursor(12));
        jl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                jl.setForeground(Color.YELLOW);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                jl.setForeground(Color.WHITE);
            }
        });
        jl.addMouseListener(lis);
        return jl;
    }

    static {
        BLUE = new Color(0, 109, 170);
        FONT_BT = new Font("Tohama", 0, 15);
    }
}

