/*
 * Decompiled with CFR 0.152.
 */
package FontViewer.windows;

import FontViewer.components.FavouriteFontsPanel;
import FontViewer.components.ListPanel;
import FontViewer.components.ListViewPanel;
import FontViewer.components.OtherFontsPanel;
import FontViewer.components.SampleTextPanel;
import FontViewer.components.SystemFontsPanel;
import FontViewer.resources.MyImageIcon;
import FontViewer.windows.dialogs.AboutDialog;
import FontViewer.windows.dialogs.TextAreaFromFileDialog;
import com.jgoodies.plaf.BorderStyle;
import com.jgoodies.plaf.HeaderStyle;
import com.jgoodies.plaf.plastic.PlasticXPLookAndFeel;
import com.jgoodies.plaf.plastic.theme.SkyBlue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class MainWindow
extends JFrame {
    private final boolean DEBUG_SIZE = false;
    private final int SYSTEM_FONTS = 0;
    private final int OTHER_FONTS = 1;
    private final int FAVOURITE_FONTS = 2;
    private final int[] FONT_SIZES = new int[]{6, 8, 9, 10, 11, 12, 14, 16, 18, 20, 24, 28, 32, 36, 42, 48, 56, 72, 84};
    private final String ADD = "Add to Favourites";
    private final String REM = "Remove from Favourites";
    private ListPanel currentPanel;
    private String fname;
    private String floc;
    private boolean typingLoc;
    private int rows = 10;
    private int columns = 1;
    private JMenuItem aboutMenuItem;
    private JMenuItem addOrRemMenuItem;
    private JMenuItem addToFavHelpMenuItem;
    private JMenuItem downMenuItem;
    private JPanel favouriteFontsPanel;
    private JMenu fileMenu;
    private JSeparator fileSep0;
    private JMenu helpMenu;
    private JSeparator helpSep0;
    private JMenu hiddenMenu;
    private JMenuItem installFontsMenuItem;
    private JCheckBoxMenuItem listViewCheckBoxMenuItem;
    private JPanel listViewPanel;
    private JSplitPane mainSplitPane;
    private JMenuBar menuBar;
    private JMenuItem nextPageMenuItem;
    private JPanel otherFontsPanel;
    private JMenuItem prevPageMenuItem;
    private JSplitPane quickViewSplitPane;
    private JMenuItem quitMenuItem;
    private JPanel sampleTextPanel;
    private JMenuItem savFavsMenuItem;
    private JMenuItem setSampleTextMenuItem;
    private JMenuItem shortcutsMenuItem;
    private JPanel systemFontsPanel;
    private JTabbedPane tabbedPane;
    private JMenuItem upMenuItem;
    private JMenu viewsMenu;

    public MainWindow() {
        try {
            PlasticXPLookAndFeel laf = new PlasticXPLookAndFeel();
            PlasticXPLookAndFeel.setMyCurrentTheme(new SkyBlue());
            UIManager.setLookAndFeel(laf);
            this.initComponents();
            this.tabbedPane.putClientProperty("jgoodies.noContentBorder", Boolean.TRUE);
            this.menuBar.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
            this.menuBar.putClientProperty("Plastic.borderStyle", BorderStyle.SEPARATOR);
            this.menuBar.requestFocus();
        }
        catch (Exception e) {
            new JOptionPane();
            JOptionPane.showMessageDialog(this, "Cannot load JGoodies look and feel.", "Error!", 0);
            this.initComponents();
        }
        this.typingLoc = false;
        this.hiddenMenu.setVisible(false);
        this.hiddenMenu.setEnabled(false);
        this.currentPanel = (ListPanel)((Object)this.systemFontsPanel);
        ((ListViewPanel)this.listViewPanel).setView(this.systemFontsPanel);
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - this.getSize().width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - this.getSize().height) / 2);
    }

    public void addToFav() {
        this.addToFav(this.fname, this.floc);
    }

    public void removeFromFav() {
        this.removeFromFav(this.fname, this.floc);
    }

    public void addToFav(String name, String loc) {
        if (!((FavouriteFontsPanel)this.favouriteFontsPanel).addToFav(name, loc)) {
            new JOptionPane();
            JOptionPane.showMessageDialog(this, "Font already in favourites.", "Error!", 0);
        } else {
            this.updateDisplay();
        }
    }

    public void removeFromFav(String name, String loc) {
        if (!((FavouriteFontsPanel)this.favouriteFontsPanel).removeFromFav(name, loc)) {
            new JOptionPane();
            JOptionPane.showMessageDialog(this, "Font not found in favourites.", "Error!", 0);
        }
    }

    public void setCurrentFont(String name, String loc, int position) {
        this.fname = name;
        this.floc = loc;
        ((ListViewPanel)this.listViewPanel).setPosition(position);
        ((SampleTextPanel)this.sampleTextPanel).setCurrentFont(name, loc);
    }

    public void setFontSize(int s) {
        if (this.listViewPanel != null) {
            ((ListViewPanel)this.listViewPanel).setFontSize(s);
        }
    }

    public void updateDisplay() {
        ((ListViewPanel)this.listViewPanel).updateDisplay();
    }

    public void setTyping(boolean t) {
        this.typingLoc = t;
        if (!t) {
            this.menuBar.requestFocus();
        }
    }

    private void saveFavToFile(File f) {
        try {
            FavouriteFontsPanel fav = (FavouriteFontsPanel)this.favouriteFontsPanel;
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            String[] s = new String[3];
            fav.sortAllRowsBy(0, true);
            for (int i = 0; i < fav.getNumItems(); ++i) {
                s = fav.getItem(i);
                bw.write(s[1] + File.separator + s[0]);
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException ioe) {
            new JOptionPane();
            JOptionPane.showMessageDialog(this, "Cannot write to file.", "Error!", 0);
        }
    }

    private void initComponents() {
        this.mainSplitPane = new JSplitPane();
        this.quickViewSplitPane = new JSplitPane();
        this.tabbedPane = new JTabbedPane();
        this.systemFontsPanel = new SystemFontsPanel(this);
        this.otherFontsPanel = new OtherFontsPanel(this);
        this.favouriteFontsPanel = new FavouriteFontsPanel(this);
        this.sampleTextPanel = new SampleTextPanel(this, this.FONT_SIZES);
        this.listViewPanel = new ListViewPanel(this, this.favouriteFontsPanel, this.rows, this.columns);
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.savFavsMenuItem = new JMenuItem();
        this.setSampleTextMenuItem = new JMenuItem();
        this.fileSep0 = new JSeparator();
        this.quitMenuItem = new JMenuItem();
        this.viewsMenu = new JMenu();
        this.listViewCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.helpMenu = new JMenu();
        this.addToFavHelpMenuItem = new JMenuItem();
        this.installFontsMenuItem = new JMenuItem();
        this.shortcutsMenuItem = new JMenuItem();
        this.helpSep0 = new JSeparator();
        this.aboutMenuItem = new JMenuItem();
        this.hiddenMenu = new JMenu();
        this.prevPageMenuItem = new JMenuItem();
        this.nextPageMenuItem = new JMenuItem();
        this.upMenuItem = new JMenuItem();
        this.downMenuItem = new JMenuItem();
        this.addOrRemMenuItem = new JMenuItem();
        this.getContentPane().setLayout(new BorderLayout(0, 5));
        this.setTitle("Opcion Font Viewer");
        this.setFont(new Font("Dialog", 0, 10));
        this.setIconImage(new MyImageIcon("IconSmall.png").getImage());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                MainWindow.this.formComponentResized(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                MainWindow.this.formWindowActivated(evt);
            }

            public void windowClosing(WindowEvent evt) {
                MainWindow.this.exitForm(evt);
            }
        });
        this.mainSplitPane.setBorder(null);
        this.mainSplitPane.setDividerSize(5);
        this.mainSplitPane.setResizeWeight(0.5);
        this.quickViewSplitPane.setBorder(null);
        this.quickViewSplitPane.setDividerSize(5);
        this.quickViewSplitPane.setOrientation(0);
        this.quickViewSplitPane.setResizeWeight(0.5);
        this.tabbedPane.setPreferredSize(new Dimension(320, 240));
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.tabbedPaneMouseClicked(evt);
            }
        });
        this.tabbedPane.addTab("System Fonts", this.systemFontsPanel);
        this.tabbedPane.addTab("Other Fonts", this.otherFontsPanel);
        this.tabbedPane.addTab("Favourite Fonts", this.favouriteFontsPanel);
        this.quickViewSplitPane.setLeftComponent(this.tabbedPane);
        this.sampleTextPanel.setPreferredSize(new Dimension(320, 240));
        this.quickViewSplitPane.setRightComponent(this.sampleTextPanel);
        this.mainSplitPane.setLeftComponent(this.quickViewSplitPane);
        this.listViewPanel.setPreferredSize(new Dimension(320, 480));
        this.mainSplitPane.setRightComponent(this.listViewPanel);
        this.getContentPane().add((Component)this.mainSplitPane, "Center");
        this.fileMenu.setMnemonic('f');
        this.fileMenu.setText("File");
        this.savFavsMenuItem.setMnemonic('s');
        this.savFavsMenuItem.setText("Save Favourites");
        this.savFavsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.savFavsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.savFavsMenuItem);
        this.setSampleTextMenuItem.setMnemonic('t');
        this.setSampleTextMenuItem.setText("Set Sample Text");
        this.setSampleTextMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.setSampleTextMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.setSampleTextMenuItem);
        this.fileMenu.add(this.fileSep0);
        this.quitMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.quitMenuItem.setMnemonic('q');
        this.quitMenuItem.setText("Quit");
        this.quitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.quitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.quitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.viewsMenu.setMnemonic('v');
        this.viewsMenu.setText("Views");
        this.listViewCheckBoxMenuItem.setMnemonic('l');
        this.listViewCheckBoxMenuItem.setSelected(true);
        this.listViewCheckBoxMenuItem.setText("List View");
        this.listViewCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.listViewCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.viewsMenu.add(this.listViewCheckBoxMenuItem);
        this.menuBar.add(this.viewsMenu);
        this.helpMenu.setMnemonic('h');
        this.helpMenu.setText("Help");
        this.addToFavHelpMenuItem.setMnemonic('f');
        this.addToFavHelpMenuItem.setText("Add Font to Favourites");
        this.addToFavHelpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.addToFavHelpMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.addToFavHelpMenuItem);
        this.installFontsMenuItem.setMnemonic('i');
        this.installFontsMenuItem.setText("Installing Fonts");
        this.installFontsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.installFontsMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.installFontsMenuItem);
        this.shortcutsMenuItem.setMnemonic('s');
        this.shortcutsMenuItem.setText("Shortcut Keys");
        this.shortcutsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.shortcutsMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.shortcutsMenuItem);
        this.helpMenu.add(this.helpSep0);
        this.aboutMenuItem.setMnemonic('a');
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.hiddenMenu.setText("hidden");
        this.prevPageMenuItem.setAccelerator(KeyStroke.getKeyStroke(44, 0));
        this.prevPageMenuItem.setText("prevPage");
        this.prevPageMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.prevPageMenuItemActionPerformed(evt);
            }
        });
        this.hiddenMenu.add(this.prevPageMenuItem);
        this.nextPageMenuItem.setAccelerator(KeyStroke.getKeyStroke(46, 0));
        this.nextPageMenuItem.setText("nextPage");
        this.nextPageMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.nextPageMenuItemActionPerformed(evt);
            }
        });
        this.hiddenMenu.add(this.nextPageMenuItem);
        this.upMenuItem.setAccelerator(KeyStroke.getKeyStroke(75, 0));
        this.upMenuItem.setText("up");
        this.upMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.upMenuItemActionPerformed(evt);
            }
        });
        this.hiddenMenu.add(this.upMenuItem);
        this.downMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, 0));
        this.downMenuItem.setText("down");
        this.downMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.downMenuItemActionPerformed(evt);
            }
        });
        this.hiddenMenu.add(this.downMenuItem);
        this.addOrRemMenuItem.setAccelerator(KeyStroke.getKeyStroke(32, 0));
        this.addOrRemMenuItem.setText("addOrRem");
        this.addOrRemMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.addOrRemMenuItemActionPerformed(evt);
            }
        });
        this.hiddenMenu.add(this.addOrRemMenuItem);
        this.menuBar.add(this.hiddenMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void addToFavHelpMenuItemActionPerformed(ActionEvent evt) {
        TextAreaFromFileDialog taffd = new TextAreaFromFileDialog(this, "Help - Add Font to Favourites", "addfavHelp.txt");
        taffd.setWrap(true);
        int x = 350;
        int y = 180;
        taffd.setBounds((Toolkit.getDefaultToolkit().getScreenSize().width - x) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - y) / 2, x, y);
        taffd.show();
    }

    private void savFavsMenuItemActionPerformed(ActionEvent evt) {
        if (((ListPanel)((Object)this.favouriteFontsPanel)).getNumItems() <= 0) {
            new JOptionPane();
            JOptionPane.showMessageDialog(this, "There are no favourite fonts to save.", "Error!", 0);
        } else {
            JFileChooser fc = new JFileChooser(new File(""));
            fc.showSaveDialog(this);
            if (fc.getSelectedFile() != null) {
                File f = fc.getSelectedFile();
                if (f.exists()) {
                    new JOptionPane();
                    if (JOptionPane.showConfirmDialog(this, "The file " + f.getName() + " already exists, do you\nwant to overwrite?", "Warning!", 0, 2) == 0) {
                        this.saveFavToFile(f);
                    }
                } else {
                    this.saveFavToFile(f);
                }
            }
        }
    }

    private void shortcutsMenuItemActionPerformed(ActionEvent evt) {
        TextAreaFromFileDialog taffd = new TextAreaFromFileDialog(this, "Help - Shortcut Keys", "shortcutsHelp.txt");
        taffd.setWrap(false);
        int x = 350;
        int y = 300;
        taffd.setBounds((Toolkit.getDefaultToolkit().getScreenSize().width - x) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - y) / 2, x, y);
        taffd.show();
    }

    private void addOrRemMenuItemActionPerformed(ActionEvent evt) {
        if (!this.typingLoc) {
            this.menuBar.requestFocus();
            if (this.currentPanel instanceof FavouriteFontsPanel) {
                this.removeFromFav();
            } else if (!((FavouriteFontsPanel)this.favouriteFontsPanel).addToFav(this.fname, this.floc)) {
                this.removeFromFav();
            } else {
                this.updateDisplay();
            }
        }
    }

    private void downMenuItemActionPerformed(ActionEvent evt) {
        if (!this.typingLoc) {
            this.menuBar.requestFocus();
            this.currentPanel.selectNext();
        }
    }

    private void nextPageMenuItemActionPerformed(ActionEvent evt) {
        if (!this.typingLoc) {
            this.menuBar.requestFocus();
            ((ListViewPanel)this.listViewPanel).nextPage();
        }
    }

    private void prevPageMenuItemActionPerformed(ActionEvent evt) {
        if (!this.typingLoc) {
            this.menuBar.requestFocus();
            ((ListViewPanel)this.listViewPanel).prevPage();
        }
    }

    private void upMenuItemActionPerformed(ActionEvent evt) {
        if (!this.typingLoc) {
            this.menuBar.requestFocus();
            this.currentPanel.selectPrev();
        }
    }

    private void setSampleTextMenuItemActionPerformed(ActionEvent evt) {
        new JOptionPane();
        String t = JOptionPane.showInputDialog(this, "Set sample text as:", "Change Sample Text", 3);
        if (t != null) {
            ((SampleTextPanel)this.sampleTextPanel).setSampleText(t);
            ((ListViewPanel)this.listViewPanel).setSampleText(t);
        }
    }

    private void formComponentResized(ComponentEvent evt) {
    }

    private void listViewCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        if (this.listViewCheckBoxMenuItem.isSelected()) {
            this.listViewPanel.setVisible(true);
            this.mainSplitPane.setDividerLocation(this.mainSplitPane.getLastDividerLocation());
            this.mainSplitPane.setEnabled(true);
        } else {
            this.mainSplitPane.setDividerLocation(1.0);
            this.mainSplitPane.setEnabled(false);
            this.listViewPanel.setVisible(false);
        }
    }

    private void tabbedPaneMouseClicked(MouseEvent evt) {
        this.currentPanel = (ListPanel)((Object)this.tabbedPane.getSelectedComponent());
        ((ListViewPanel)this.listViewPanel).setView((JPanel)((Object)this.currentPanel));
        String[] s = this.currentPanel.getCurrentItem();
        if (s[0] != null) {
            this.setCurrentFont(s[0], s[1], Integer.parseInt(s[2]));
        }
        if (this.currentPanel instanceof FavouriteFontsPanel) {
            ((SampleTextPanel)this.sampleTextPanel).setFavButtonAction("Remove from Favourites");
        } else {
            ((SampleTextPanel)this.sampleTextPanel).setFavButtonAction("Add to Favourites");
        }
    }

    private void installFontsMenuItemActionPerformed(ActionEvent evt) {
        TextAreaFromFileDialog taffd = new TextAreaFromFileDialog(this, "Help - Installing Fonts", "installHelp.txt");
        taffd.setWrap(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        taffd.setBounds((screenSize.width - 480) / 2, (screenSize.height - 295) / 2, 480, 295);
        taffd.show();
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        new AboutDialog(this).show();
    }

    private void quitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void formWindowActivated(WindowEvent evt) {
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }
}

